<!doctype html>
<?php if($global_setting->layout_direction == 'LTR'): ?>
<html lang="en" dir="ltr">
<?php else: ?>
<html lang="en" dir="rtl">
<?php endif; ?>
<head>
    <meta charset="utf-8">
    <meta http-equiv="x-ua-compatible" content="ie=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link rel="icon" type="image/png" href="<?php echo e(asset('uploads/'.$global_setting->favicon)); ?>">

    <?php echo $__env->make('front.layouts.style', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

    <?php if(Route::is('home')): ?>
        <title><?php echo e($global_page_item->home_seo_title); ?></title>
        <meta name="description" content="<?php echo e($global_page_item->home_seo_meta_description); ?>">
    <?php endif; ?>

    <?php if(Route::is('about')): ?>
        <title><?php echo e($global_page_item->about_seo_title); ?></title>
        <meta name="description" content="<?php echo e($global_page_item->about_seo_meta_description); ?>">
    <?php endif; ?>

    <?php if(Route::is('services')): ?>
        <title><?php echo e($global_page_item->services_seo_title); ?></title>
        <meta name="description" content="<?php echo e($global_page_item->services_seo_meta_description); ?>">
    <?php endif; ?>

    <?php if(Route::is('service')): ?>
        <?php
        $service = App\Models\Service::where('slug', $service->slug)->first();
        ?>
        <title><?php echo e($service->seo_title); ?></title>
        <meta name="description" content="<?php echo e($service->seo_meta_description); ?>">
    <?php endif; ?>

    <?php if(Route::is('projects')): ?>
        <title><?php echo e($global_page_item->projects_seo_title); ?></title>
        <meta name="description" content="<?php echo e($global_page_item->projects_seo_meta_description); ?>">
    <?php endif; ?>

    <?php if(Route::is('project')): ?>
        <?php
        $project = App\Models\Project::where('slug', $project->slug)->first();
        ?>
        <title><?php echo e($project->seo_title); ?></title>
        <meta name="description" content="<?php echo e($project->seo_meta_description); ?>">
    <?php endif; ?>

    <?php if(Route::is('lawyers')): ?>
        <title><?php echo e($global_page_item->lawyers_seo_title); ?></title>
        <meta name="description" content="<?php echo e($global_page_item->lawyers_seo_meta_description); ?>">
    <?php endif; ?>

    <?php if(Route::is('faq')): ?>
        <title><?php echo e($global_page_item->faq_seo_title); ?></title>
        <meta name="description" content="<?php echo e($global_page_item->faq_seo_meta_description); ?>">
    <?php endif; ?>

    <?php if(Route::is('pricing')): ?>
        <title><?php echo e($global_page_item->pricing_seo_title); ?></title>
        <meta name="description" content="<?php echo e($global_page_item->pricing_seo_meta_description); ?>">
    <?php endif; ?>

    <?php if(Route::is('photo_gallery')): ?>
        <title><?php echo e($global_page_item->photo_gallery_seo_title); ?></title>
        <meta name="description" content="<?php echo e($global_page_item->photo_gallery_seo_meta_description); ?>">
    <?php endif; ?>

    <?php if(Route::is('video_gallery')): ?>
        <title><?php echo e($global_page_item->video_gallery_seo_title); ?></title>
        <meta name="description" content="<?php echo e($global_page_item->video_gallery_seo_meta_description); ?>">
    <?php endif; ?>

    <?php if(Route::is('contact')): ?>
        <title><?php echo e($global_page_item->contact_seo_title); ?></title>
        <meta name="description" content="<?php echo e($global_page_item->contact_seo_meta_description); ?>">
    <?php endif; ?>

    <?php if(Route::is('appointment')): ?>
        <title><?php echo e($global_page_item->appointment_seo_title); ?></title>
        <meta name="description" content="<?php echo e($global_page_item->appointment_seo_meta_description); ?>">
    <?php endif; ?>

    <?php if(Route::is('terms')): ?>
        <title><?php echo e($global_page_item->terms_seo_title); ?></title>
        <meta name="description" content="<?php echo e($global_page_item->terms_seo_meta_description); ?>">
    <?php endif; ?>

    <?php if(Route::is('privacy')): ?>
        <title><?php echo e($global_page_item->privacy_seo_title); ?></title>
        <meta name="description" content="<?php echo e($global_page_item->privacy_seo_meta_description); ?>">
    <?php endif; ?>

    <?php if(Route::is('blog')): ?>
        <title><?php echo e($global_page_item->blog_seo_title); ?></title>
        <meta name="description" content="<?php echo e($global_page_item->blog_seo_meta_description); ?>">
    <?php endif; ?>

    <?php if(Route::is('post')): ?>
        <?php
        $post = App\Models\Post::where('slug', $post->slug)->first();
        ?>
        <title><?php echo e($post->seo_title); ?></title>
        <meta name="description" content="<?php echo e($post->seo_meta_description); ?>">
    <?php endif; ?>

    <?php if(Route::is('category')): ?>
        <title><?php echo e($global_page_item->blog_category_seo_title); ?></title>
        <meta name="description" content="<?php echo e($global_page_item->blog_category_seo_meta_description); ?>">
    <?php endif; ?>

    <?php if(Route::is('tag')): ?>
        <title><?php echo e($global_page_item->blog_tag_seo_title); ?></title>
        <meta name="description" content="<?php echo e($global_page_item->blog_tag_seo_meta_description); ?>">
    <?php endif; ?>

    <?php if(Route::is('search')): ?>
        <title><?php echo e($global_page_item->blog_search_page_title); ?></title>
        <meta name="description" content="<?php echo e($global_page_item->blog_search_page_meta_description); ?>">
    <?php endif; ?>

    <?php if(Route::is('post') && isset($post)): ?>
        <meta property="og:title" content="<?php echo e($post->title); ?>">
        <meta property="og:description" content="<?php echo e($post->short_description); ?>">
        <meta property="og:image" content="<?php echo e(asset('uploads/'.$post->photo)); ?>">
        <meta property="og:photo" content="<?php echo e(asset('uploads/'.$post->photo)); ?>">
        <meta property="og:url" content="<?php echo e(route('post', $post->slug)); ?>">
        <meta property="og:type" content="article">
        <meta property="og:site_name" content="<?php echo e(env('APP_NAME')); ?>">
        <meta property="og:image:alt" content="<?php echo e($post->title); ?>">
        <meta name="twitter:card" content="summary_large_image">
        <meta name="twitter:title" content="<?php echo e($post->title); ?>">
        <meta name="twitter:description" content="<?php echo e($post->short_description); ?>">
        <meta name="twitter:image" content="<?php echo e(asset('uploads/'.$post->photo)); ?>">
        <?php if(!empty($post->tags)): ?>
            <?php $tags = array_filter(array_map('trim', explode(',', $post->tags))); ?>
            <?php $__currentLoopData = $tags; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <meta property="article:tag" content="<?php echo e($t); ?>">
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        <?php endif; ?>
        <?php if(!empty($post->created_at)): ?>
            <meta property="article:published_time" content="<?php echo e($post->created_at->toIso8601String()); ?>">
        <?php endif; ?>
        <?php if(!empty($post->updated_at)): ?>
            <meta property="article:modified_time" content="<?php echo e($post->updated_at->toIso8601String()); ?>">
        <?php endif; ?>
    <?php endif; ?>

    <?php if($global_setting->google_analytic_status == 'Show'): ?>
    <!-- Google tag (gtag.js) -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=<?php echo e($global_setting->google_analytic_measurement_id); ?>"></script>
    <script>
        window.dataLayer = window.dataLayer || [];
        function gtag(){dataLayer.push(arguments);}
        gtag('js', new Date());

        gtag('config', '<?php echo e($global_setting->google_analytic_measurement_id); ?>');
    </script>
    <?php endif; ?>

    <?php if($global_setting->sticky_header_status == 'Hide'): ?>
    <style>
        .sticky-menu {
            display: none;
        }
    </style>
    <?php endif; ?>

    <style>
        :root {
            --tg-theme-primary: #<?php echo e($global_setting->theme_color_1); ?>;
        }
        .wcu-card .box-icon svg,
        .service-card .box-icon svg {
            stroke: #<?php echo e($global_setting->theme_color_1); ?>;
        }

        .tg-header__area-four.sticky-menu,
        .lawyer-area-3,
        .footer__area-one,
        .testimonial-wrap3 {
            background: #<?php echo e($global_setting->theme_color_2); ?>;
        }

        .footer__top-two .footer-contact .footer-contact_icon,
        .social-links.style3 .list-wrap a,
        .footer__area-three .footer__bottom {
            background: #<?php echo e($global_setting->theme_color_3); ?>;
        }
    </style>

</head>

<body class="white-bg">

    <?php if($global_setting->preloader_status == 'Show'): ?>
    <!--Preloader-->
    <div id="preloader" class="white-bg">
        <div id="loader" class="loader">
            <div class="loader-container">
                <div class="loader-icon"><img src="<?php echo e(asset('uploads/'.$global_setting->preloader_photo)); ?>" alt="Preloader"></div>
            </div>
        </div>
    </div>
    <!--Preloader-end -->
    <?php endif; ?>

    <!-- Scroll-top -->
    <button class="scroll__top scroll-to-target" data-target="html">
        <i class="fas fa-arrow-up"></i>
    </button>
    <!-- Scroll-top-end-->

    <?php if(
        !app()->isDownForMaintenance() &&
        !(isset($exception) && in_array($exception->getStatusCode(), [404, 503]))
    ): ?>
    <?php if(Route::is('home')): ?>
    <?php echo $__env->make('front.layouts.nav_home', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php else: ?>
    <?php echo $__env->make('front.layouts.nav', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php endif; ?>
    <?php endif; ?>

    <!-- main-area -->
    <main class="fix">

    <?php echo $__env->yieldContent('main_content'); ?>

    </main>
    <!-- main-area-end -->


    <?php if(
        !app()->isDownForMaintenance() &&
        !(isset($exception) && in_array($exception->getStatusCode(), [404, 503]))
    ): ?>
    <?php echo $__env->make('front.layouts.footer', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php echo $__env->make('front.layouts.script', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
    <?php endif; ?>
</body>

</html>
<?php /**PATH /Applications/MAMP/htdocs/phpscriptpoint/lawyer/lawyer/cms/main_files/resources/views/front/layouts/master.blade.php ENDPATH**/ ?>