<?php if($global_page_item->blog_sidebar_search_status == 'Show'): ?>
<div class="blog-widget">
    <h4 class="widget-title"><?php echo e(__('Search Here')); ?></h4>
    <div class="sidebar-search-form">
        <form action="<?php echo e(route('search')); ?>" method="get">
            <input type="text" placeholder="<?php echo e(__('Enter Keyword')); ?>" name="text">
            <button type="submit"><i class="fas fa-search"></i></button>
        </form>
    </div>
</div>
<?php endif; ?>

<?php if($global_page_item->blog_sidebar_category_status == 'Show'): ?>
<div class="blog-widget">
    <h4 class="widget-title"><?php echo e(__('Categories')); ?></h4>
    <div class="sidebar-cat-list">
        <ul class="list-wrap">
            <?php
            $all_categories = App\Models\PostCategory::orderBy('name','asc')->get();
            ?>
            <?php $__currentLoopData = $all_categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li><a href="<?php echo e(route('category',$item->slug)); ?>"><?php echo e($item->name); ?> <span><i class="fas fa-arrow-right"></i></span></a></li>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </ul>
    </div>
</div>
<?php endif; ?>

<?php if($global_page_item->blog_sidebar_recent_post_status == 'Show'): ?>
<div class="blog-widget widget-rc-post">
    <h4 class="widget-title"><?php echo e(__('Recent Posts')); ?></h4>
    <div class="rc-post-wrap">
        <?php
        $all_recent_posts = App\Models\Post::orderBy('id','desc')->limit($global_page_item->blog_sidebar_recent_post_total)->get();
        ?>
        <?php $__currentLoopData = $all_recent_posts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="rc-post-item">
            <div class="thumb">
                <a href="<?php echo e(route('post',$item->slug)); ?>"><img src="<?php echo e(asset('uploads/'.$item->photo)); ?>" alt="img"></a>
            </div>
            <div class="content">
                <span class="date"><i class="far fa-clock"></i><?php echo e($item->created_at->format('d M, Y')); ?></span>
                <h4 class="title"><a href="<?php echo e(route('post',$item->slug)); ?>"><?php echo e($item->title); ?></a></h4>
            </div>
        </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </div>
</div>
<?php endif; ?>


<?php if($global_page_item->blog_sidebar_tag_status == 'Show'): ?>
<?php
$tags = App\Models\Post::pluck('tags')->flatMap(function ($item) {
    return explode(',', $item);
})->unique()->values();
?>
<?php if(count($tags) != 0): ?>
<div class="blog-widget">
    <h3 class="widget-title"><?php echo e(__('Popular Tags')); ?></h3>
    <div class="sidebar-tag-list">
        <ul class="list-wrap">
            <?php for($i=0;$i<count($tags);$i++): ?>
            <li>
                <a href="<?php echo e(route('tag', $tags[$i])); ?>"><?php echo e($tags[$i]); ?></a>
            </li>
            <?php endfor; ?>
        </ul>
    </div>
</div>
<?php endif; ?>
<?php endif; ?><?php /**PATH /Applications/MAMP/htdocs/arefindigital/lawyer_sohel/main_files/resources/views/front/layouts/blog_sidebar.blade.php ENDPATH**/ ?>