<?php $__env->startSection('main_content'); ?>
<?php echo $__env->make('admin.layouts.nav', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php echo $__env->make('admin.layouts.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

<div class="main-content">
    <section class="section">
        <div class="section-header d-flex justify-content-between">
            <h1><?php echo e(__('Edit Service')); ?></h1>
            <div class="ml-auto">
                <a href="<?php echo e(route('admin_service_index')); ?>" class="btn btn-primary"><i class="fas fa-plus"></i> <?php echo e(__('View All')); ?></a>
            </div>
        </div>
        <div class="section-body">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-body">
                            <form action="<?php echo e(route('admin_service_update',$service->id)); ?>" method="post" enctype="multipart/form-data">
                                <?php echo csrf_field(); ?>
                                <div class="row">
                                    <div class="col-lg-12 mb-3">
                                        <label for=""><?php echo e(__('Existing Photo')); ?></label>
                                        <div>
                                            <img src="<?php echo e(asset('uploads/'.$service->photo)); ?>" alt="" class="w_200">
                                        </div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-4 mb-3">
                                        <label for=""><?php echo e(__('Change Photo')); ?></label>
                                        <div><input type="file" name="photo" class="form-control"></div>
                                    </div>
                                </div>
                                <div class="row">
                                    <div class="col-lg-6 mb-3">
                                        <label for=""><?php echo e(__('Name')); ?> *</label>
                                        <input type="text" name="name" class="form-control" value="<?php echo e($service->name); ?>">
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <label for=""><?php echo e(__('Slug')); ?> *</label>
                                        <input type="text" name="slug" class="form-control" value="<?php echo e($service->slug); ?>">
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <label for=""><?php echo e(__('Icon Code')); ?> *</label>
                                        <textarea name="icon_code" class="form-control h_100"><?php echo e($service->icon_code); ?></textarea>
                                    </div>
                                    <div class="col-lg-6 mb-3">
                                        <label for=""><?php echo e(__('Short Description')); ?> *</label>
                                        <textarea name="short_description" class="form-control h_100"><?php echo e($service->short_description); ?></textarea>
                                    </div>
                                    <div class="col-lg-12 mb-3">
                                        <label for=""><?php echo e(__('Description')); ?> *</label>
                                        <textarea name="description" class="form-control editor"><?php echo e($service->description); ?></textarea>
                                    </div>
                                    <div class="col-lg-12 mb-3">
                                        <label for=""><?php echo e(__('Phone')); ?></label>
                                        <input type="text" name="phone" class="form-control" value="<?php echo e($service->phone); ?>">
                                    </div>
                                    <div class="col-lg-12 mb-3">
                                        <label for=""><?php echo e(__('SEO Title')); ?></label>
                                        <input type="text" name="seo_title" class="form-control" value="<?php echo e($service->seo_title); ?>">
                                    </div>
                                    <div class="col-lg-12 mb-3">
                                        <label for=""><?php echo e(__('SEO Meta Description')); ?></label>
                                        <textarea name="seo_meta_description" class="form-control h_100"><?php echo e($service->seo_meta_description); ?></textarea>
                                    </div>
                                    <div class="col-lg-12 mb-3">
                                        <button type="submit" class="btn btn-primary"><?php echo e(__('Update')); ?></button>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>



<script>
    document.addEventListener('DOMContentLoaded', function() {
    const nameInput = document.querySelector('input[name="name"]');
    const slugInput = document.querySelector('input[name="slug"]');

    if (nameInput && slugInput) {
        nameInput.addEventListener('keyup', function() {
            let name = this.value;
            let slug = name.toLowerCase()
                           .replace(/ /g, '-')
                           .replace(/[^\w-]+/g, '')
                           .replace(/-+$/, '');

            slugInput.value = slug;
        });
    }
});
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.layouts.master', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /Applications/MAMP/htdocs/arefindigital/lawyer_sohel/main_files/resources/views/admin/service/edit.blade.php ENDPATH**/ ?>