(function ($) {
	"use strict";

/*=============================================
	=    		 Preloader			      =
=============================================*/
function preloader() {
	$('#preloader').delay(0).fadeOut();
};

$(window).on('load', function () {
	preloader();
	wowAnimation();
    aosAnimation();
});



/*===========================================
	=    		Mobile Menu			      =
=============================================*/
//SubMenu Dropdown Toggle
if ($('.tgmenu__wrap li.menu-item-has-children ul').length) {
	$('.tgmenu__wrap .navigation li.menu-item-has-children').append('<div class="dropdown-btn"><span class="plus-line"></span></div>');
}

//Mobile Nav Hide Show
if ($('.tgmobile__menu').length) {

	var mobileMenuContent = $('.tgmenu__wrap .tgmenu__main-menu').html();
	$('.tgmobile__menu .tgmobile__menu-box .tgmobile__menu-outer').append(mobileMenuContent);

	//Dropdown Button
	$('.tgmobile__menu li.menu-item-has-children .dropdown-btn').on('click', function () {
		$(this).toggleClass('open');
		$(this).prev('ul').slideToggle(300);
	});
	//Menu Toggle Btn
	$('.mobile-nav-toggler').on('click', function () {
		$('body').addClass('mobile-menu-visible');
	});

	//Menu Toggle Btn
	$('.tgmobile__menu-backdrop, .tgmobile__menu .close-btn').on('click', function () {
		$('body').removeClass('mobile-menu-visible');
	});
};


/*=============================================
	=           Data Background             =
=============================================*/
$("[data-background]").each(function () {
	$(this).css("background-image", "url(" + $(this).attr("data-background") + ")")
})
$("[data-bg-color]").each(function () {
    $(this).css("background-color", $(this).attr("data-bg-color"));
});

$("[data-text-color]").each(function () {
    $(this).css("color", $(this).attr("data-text-color"));
});

/*=============================================
	=           Data Mask Src             =
=============================================*/
if ($('[data-mask-src]').length > 0) {
    $('[data-mask-src]').each(function () {
      var mask = $(this).attr('data-mask-src');
      $(this).css({
        'mask-image': 'url(' + mask + ')',
        '-webkit-mask-image': 'url(' + mask + ')'
      });
      $(this).addClass('bg-mask');
      $(this).removeAttr('data-mask-src');
    });
};

/*===========================================
	=     Menu sticky & Scroll to top      =
=============================================*/
$(window).on('scroll', function () {
	var scroll = $(window).scrollTop();
	if (scroll < 245) {
		$("#sticky-header").removeClass("sticky-menu");
		$('.scroll-to-target').removeClass('open');
        $("#header-fixed-height").removeClass("active-height");

	} else {
		$("#sticky-header").addClass("sticky-menu");
		$('.scroll-to-target').addClass('open');
        $("#header-fixed-height").addClass("active-height");
	}
});


/*=============================================
	=    		 Scroll Up  	         =
=============================================*/
if ($('.scroll-to-target').length) {
  $(".scroll-to-target").on('click', function () {
    var target = $(this).attr('data-target');
    // animate
    $('html, body').animate({
      scrollTop: $(target).offset().top
    }, 1000);

  });
}


/*===========================================
	=            Search Active            =
=============================================*/
function popupSarchBox($searchBox, $searchOpen, $searchCls, $toggleCls) {
    $($searchOpen).on("click", function (e) {
        e.preventDefault();
        $($searchBox).addClass($toggleCls);
    });
    $($searchBox).on("click", function (e) {
        e.stopPropagation();
        $($searchBox).removeClass($toggleCls);
    });
    $($searchBox)
        .find("form")
        .on("click", function (e) {
            e.stopPropagation();
            $($searchBox).addClass($toggleCls);
        });
    $($searchCls).on("click", function (e) {
        e.preventDefault();
        e.stopPropagation();
        $($searchBox).removeClass($toggleCls);
    });
}
popupSarchBox(
    ".popup-search-box",
    ".searchBoxToggler",
    ".searchClose",
    "show"
);


/*=============================================
=     Offcanvas Menu      =
=============================================*/
$(".menu-tigger").on("click", function () {
	$(".offCanvas__info, .offCanvas__overly").addClass("active");
	return false;
});
$(".menu-close, .offCanvas__overly").on("click", function () {
	$(".offCanvas__info, .offCanvas__overly").removeClass("active");
});


/*=============================================
    =          Swiper active              =
=============================================*/
$('.tg-swiper__slider').each(function () {
    var thmSwiperSlider = $(this);
    var settings = $(this).data('swiper-options');

    // Store references to the navigation and pagination elements
    var prevArrow = thmSwiperSlider.find('.slider-prev');
    var nextArrow = thmSwiperSlider.find('.slider-next');
    var paginationEl = thmSwiperSlider.find('.slider-pagination');
    var customPaginationEl = thmSwiperSlider.find('.slider-pagination2'); // Custom number pagination container

    var autoplayCondition = settings['autoplay'];

    var sliderDefault = { 
        slidesPerView: 1,
        spaceBetween: settings['spaceBetween'] ? settings['spaceBetween'] : 24,
        loop: settings['loop'] === false ? false : true,
        speed: settings['speed'] ? settings['speed'] : 1000,
        autoplay: autoplayCondition ? autoplayCondition : { delay: 6000, disableOnInteraction: false },
        navigation: {
            nextEl: nextArrow.get(0),
            prevEl: prevArrow.get(0),  
        },
        pagination: {
            el: paginationEl.get(0),
            clickable: true,
            renderBullet: function (index, className) {
                return '<span class="' + className + '" aria-label="Go to Slide ' + (index + 1) + '"></span>';
            },
        },
        on: {
            init: function () {
                updateFractionPagination(this); // Update fraction pagination on init
                updateCustomNumberPagination(this, customPaginationEl); // Update custom number pagination on init
            },
            slideChange: function () {
                updateFractionPagination(this); // Update fraction pagination on slide change
                updateCustomNumberPagination(this, customPaginationEl); // Update custom number pagination on slide change
            }
        },
    };

    var options = JSON.parse(thmSwiperSlider.attr('data-swiper-options'));
    options = $.extend({}, sliderDefault, options);
    var swiper = new Swiper(thmSwiperSlider.get(0), options); // Assign the swiper variable

    if ($('.slider-area').length > 0) {
        $('.slider-area').closest(".container").parent().addClass("arrow-wrap");
    }
});

// Function to update fraction pagination
function updateFractionPagination(swiper) {
    var current = swiper.realIndex + 1; // realIndex gives the current slide
    var total = swiper.slides.length - swiper.loopedSlides * 2; // Adjust for looped slides
    var paginationElement = swiper.pagination.el;

    // Update fraction pagination with current/total
    $(paginationElement).find('.fraction-pagination').html(current + ' / ' + total);
}

// Function to update custom number pagination with leading zeros
function updateCustomNumberPagination(swiper, customPaginationEl) {
    var current = swiper.realIndex + 1; // Get the current slide index
    var total = swiper.slides.length - swiper.loopedSlides * 0; // Adjust for looped slides

    // Create custom pagination HTML with leading zeros
    var customPaginationHTML = '';
    for (var i = 1; i <= total; i++) {
        var isActive = i === current ? 'active' : ''; // Highlight the current slide
        var formattedNumber = i.toString().padStart(2, '0'); // Add leading zero
        customPaginationHTML += `<span class="custom-page ${isActive}" data-slide="${i}">${formattedNumber}</span>`;
    }

    // Update the custom pagination element
    customPaginationEl.html(customPaginationHTML);

    // Add click event to custom pagination numbers
    customPaginationEl.find('.custom-page').on('click', function () {
        var targetSlide = $(this).data('slide') - 1; // Convert to zero-based index
        swiper.slideToLoop(targetSlide); // Slide to the target index (adjust for loop)
    });
}

// Function to add animation classes
function animationProperties() {
    $('[data-ani]').each(function () {
        var animationName = $(this).data('ani');
        $(this).addClass(animationName);
    });

    $('[data-ani-delay]').each(function () {
        var delayTime = $(this).data('ani-delay');
        $(this).css('animation-delay', delayTime);
    });
}
animationProperties();

// Add click event handlers for external slider arrows based on data attributes
$('[data-slider-prev], [data-slider-next]').on('click', function () {
    var sliderSelector = $(this).data('slider-prev') || $(this).data('slider-next');
    var targetSlider = $(sliderSelector);

    if (targetSlider.length) {
        var swiper = targetSlider[0].swiper;

        if (swiper) {
            if ($(this).data('slider-prev')) {
                swiper.slidePrev(); 
            } else {
                swiper.slideNext(); 
            }
        }
    }
});

/*=============================================
	=    		Magnific Popup		      =
=============================================*/
$('.popup-image').magnificPopup({
	type: 'image',
	gallery: {
		enabled: true
	}
});

/* magnificPopup video view */
$('.popup-video').magnificPopup({
	type: 'iframe',
    gallery: {
        enabled: true,
    },
});


/*=============================================
	=    		 Wow Active  	         =
=============================================*/
function wowAnimation() {
	var wow = new WOW({
		boxClass: 'wow',
		animateClass: 'animated',
		offset: 0,
		mobile: false,
		live: true
	});
	wow.init();
}

/*=============================================
	=           Aos Active       =
=============================================*/
function aosAnimation() {
	AOS.init({
		duration: 1000,
		mirror: true,
		once: true,
		disable: 'mobile',
	});
}

/*=============================================
	=           Counter Number       =
=============================================*/
$(".counter-number").counterUp({
	delay: 10,
	time: 1000,
});

/*=============================================
	=           Progress Counter       =
=============================================*/
$('.progress-bar').waypoint(function() {
	$('.progress-bar').css({
	animation: "animate-positive 1.8s",
	opacity: "1"
	});
}, { offset: '100%' });


/*=============================================
	=           Masonary Active       =
=============================================*/
$(".masonary-active").imagesLoaded(function () {
    var $filter = ".masonary-active",
        $filterItem = ".filter-item",
        $filterMenu = ".filter-menu-active";

    if ($($filter).length > 0) {
        var $grid = $($filter).isotope({
            itemSelector: $filterItem,
            filter: "*",
            masonry: {
                // use outer width of grid-sizer for columnWidth
                columnWidth: 1,
            },
        });

        // filter items on button click
        $($filterMenu).on("click", "button", function () {
            var filterValue = $(this).attr("data-filter");
            $grid.isotope({
                filter: filterValue,
            });
        });

        // Menu Active Class
        $($filterMenu).on("click", "button", function (event) {
            event.preventDefault();
            $(this).addClass("active");
            $(this).siblings(".active").removeClass("active");
        });
    }
});

/*=============================================
	=           Date Time Picker       =
=============================================*/
// Only Date Picker
$('.date-pick').datetimepicker({
    timepicker: false,
    datepicker: true,
    format: 'd-m-y',
    step: 10
});

    // Only Time Picker
$('.time-pick').datetimepicker({
    datepicker:false,
    format:'H:i',
    step:30
});

    // Date Time
$('.date-time-pick').datetimepicker({
        
});


/*=============================================
	=           Smooth Scroll       =
=============================================*/
if (window.gsap && window.ScrollTrigger && window.Lenis) {
        gsap.registerPlugin(ScrollTrigger);

        const lenis = new Lenis({
            lerp: 0.07
        });

        lenis.on('scroll', ScrollTrigger.update);

        gsap.ticker.add((time)=>{
            lenis.raf(time * 1000)
        })
}


/*=============================================
	=           Gsap text Animation       =
=============================================*/
if ($('.text-anim').length && window.gsap && window.SplitText) {
    let staggerAmount = 0.05,
        translateXValue = 20,
        delayValue = 0.5,
        easeType = "power2.out",
        animatedTextElements = document.querySelectorAll('.text-anim');

    animatedTextElements.forEach((element) => {
        let animationSplitText = new SplitText(element, {
            type: "chars, words"
        });
        gsap.from(animationSplitText.chars, {
            duration: 1,
            delay: delayValue,
            x: translateXValue,
            autoAlpha: 0,
            stagger: staggerAmount,
            ease: easeType,
                scrollTrigger: window.ScrollTrigger ? {
                    trigger: element,
                    start: "top 85%"
                } : undefined,
        });
    });
}

if ($('.text-anim2').length && window.gsap && window.SplitText) {				
    let	 staggerAmount 		= 0.03,
         translateXValue	= 20,
         delayValue 		= 0.1,
         easeType 			= "power2.out",
         animatedTextElements = document.querySelectorAll('.text-anim2');
    
    animatedTextElements.forEach((element) => {
        let animationSplitText = new SplitText(element, { type: "chars, words" });
            gsap.from(animationSplitText.chars, {
                duration: 1,
                delay: delayValue,
                x: translateXValue,
                autoAlpha: 0,
                stagger: staggerAmount,
                ease: easeType,
                scrollTrigger: window.ScrollTrigger ? { trigger: element, start: "top 85%"} : undefined,
            });
    });		
}


$(".form_subscribe_ajax").on('submit', function(e){
    e.preventDefault();
    $('#ajax-loader').show();
    var form = this;
    $.ajax({
        url:$(form).attr('action'),
        method:$(form).attr('method'),
        data:new FormData(form),
        processData:false,
        dataType:'json',
        contentType:false,
        beforeSend:function(){
            //$(form).find('span.error-text').text('');
        },
        success:function(data)
        {
            $('#ajax-loader').hide();
            if(data.code == 0)
            {
                if (typeof data.error_message === 'string') {
                    const Toast = Swal.mixin({
                        toast: true,
                        position: "top-end",
                        showConfirmButton: false,
                        timer: 1500,
                        timerProgressBar: true,
                        didOpen: (toast) => {
                            toast.onmouseenter = Swal.stopTimer;
                            toast.onmouseleave = Swal.resumeTimer;
                        }
                    });
                    Toast.fire({
                        icon: 'error',
                        title: data.error_message
                    });
                } else {
                    $.each(data.error_message, function(prefix, val) {
                        $(form).find('span.'+prefix+'_error').text(val[0]);
                        const Toast = Swal.mixin({
                            toast: true,
                            position: "top-end",
                            showConfirmButton: false,
                            timer: 1500,
                            timerProgressBar: true,
                            didOpen: (toast) => {
                                toast.onmouseenter = Swal.stopTimer;
                                toast.onmouseleave = Swal.resumeTimer;
                            }
                        });
                        Toast.fire({
                            icon: 'error',
                            title: val[0]
                        });
                    });
                }
            }
            else if(data.code == 1)
            {
                $(form)[0].reset();
                const Toast = Swal.mixin({
                    toast: true,
                    position: "top-end",
                    showConfirmButton: false,
                    timer: 1500,
                    timerProgressBar: true,
                    didOpen: (toast) => {
                        toast.onmouseenter = Swal.stopTimer;
                        toast.onmouseleave = Swal.resumeTimer;
                    }
                });
                Toast.fire({
                    icon: "success",
                    title: data.success_message
                });
            }
            
        },
        error:function()
        {
            $('#ajax-loader').hide();
            const Toast = Swal.mixin({
                toast: true,
                position: "top-end",
                showConfirmButton: false,
                timer: 1500,
                timerProgressBar: true,
                didOpen: (toast) => {
                    toast.onmouseenter = Swal.stopTimer;
                    toast.onmouseleave = Swal.resumeTimer;
                }
            });
            Toast.fire({
                icon: 'error',
                title: 'Request failed. Please try again.'
            });
        }
    });
});
})(jQuery);